﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using MeridiaAPIWrapper;
using MeridiaAPIWrapper.QuestionTypes;

namespace MeridiaArs.MeridiaApiTestApp
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        BaseControllerSimple baseController = null;

        public MainWindow()
        {
            InitializeComponent();
            // Configuring log directory path
            ConfigSimple.LogDirectoryPath = @"d:\";

            baseController = new BaseControllerSimple();
            BindApiEvents();
        }

        private void btnConnectAll_Click(object sender, RoutedEventArgs e)
        {
            DisableButtons();
            // This will mark all plugged-in Meridia Bases as connected
            baseController.ConnectAllBases();
            ChangeOutputText("Please wait for HardwareInitializationComplete event to be raised.");
        }

        private void BaseController_OnKeypadResponse(string sessionID, string portAddress, long baseID, long baseAddress, long keypadAddress, long keypadSerialNumber, long timeStamp, long batteryLevel, long firmwareVersionMajor, long firmwareVersionMinor, string selectedOption)
        {
            MessageBox.Show(selectedOption);
        }

        private void BaseController_HardwareInitializationComplete(int numberOfEnabledBases, int numberOfDetectedBases)
        {
            MessageBox.Show("Hardware Initialization Complete");
            // Call this method as it's required by EZ-VOTE HD/PRO hardware
            baseController.ExitBackgroundSignin();
            // As events are not raised in UI thread. 
            // So we have to use dispatcher in order to update UI
            Dispatcher.Invoke(EnableButtons);
            Dispatcher.Invoke(new Action(() => ChangeOutputText("You can start polling.")));
        }

        private void EnableButtons()
        {
            btnClosePolling.IsEnabled = true;
            btnStartPolling.IsEnabled = true;
        }

        private void DisableButtons()
        {
            btnClosePolling.IsEnabled = false;
            btnStartPolling.IsEnabled = false;
        }
        

        private void ChangeOutputText (string text)
        {
            txtOutput.Text = text;
        }
        private void BindApiEvents()
        {
            // Event is raised when base is detected by the API and marked connected
            baseController.OnBaseProperties += BaseController_OnBaseProperties;

            // Event is raised when hardware initialization is completed. 
            baseController.HardwareInitializationComplete += BaseController_HardwareInitializationComplete;

            // Event is raised Meridia Base receives a valid vote from any keypad. 
            baseController.OnKeypadResponse += BaseController_OnKeypadResponse;
        }

        private void BaseController_OnBaseProperties(string portAddress, long baseID, long baseAddress, long baseFirmwareMajor, long baseFirmwareMinor, string baseSerialNumber, ref PollingGroupsSimple pollingGroups)
        {
            MessageBox.Show("Base Dectected: " + portAddress);
            // Call this method as it's required by EZ-VOTE HD/PRO hardware
            baseController.SetBaseProperties(portAddress, baseID.ToString(), baseAddress.ToString());
        }

        private void btnStartPolling_Click(object sender, RoutedEventArgs e)
        {
            ChoiceSimple choice = new ChoiceSimple() {
                LessEnabled = EnumsSimple.LessEnabled.Allowed,
                ModifyMode = EnumsSimple.ModifyMode.Modifiable,
                OptionalN = 1,
                OptionMode = EnumsSimple.OptionsMode.Number,
                Options = 9,
                SecracyMode = EnumsSimple.SecrecyMode.Unclassified,
                StartMode = EnumsSimple.StartMode.StartAfresh                                
            };

            baseController.OpenPolling(Choice: choice);
            ChangeOutputText("Polling is open.");
        }
        private void btnClosePolling_Click(object sender, RoutedEventArgs e)
        {
            baseController.ClosePolling();
            ChangeOutputText("Polling is closed.");
        }
    }
}
